<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Aliment extends Model 
{

    protected $table = 'aliments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('slug', 'stock', 'seuil', 'id_unite', 'unite_sortie', 'name', 'description', 'notificationSeuil', 'statut');
    protected $visible = array('slug', 'stock', 'seuil', 'id_unite', 'unite_sortie', 'name', 'description', 'notificationSeuil', 'statut');

    public function alimentVague()
    {
        return $this->hasMany('App\Models\AlimentVague', 'id_aliment');
    }

    public function unite()
    {
        return $this->belongsTo('App\Models\Unite', 'id_unite');
    }

    public function mouvementStock()
    {
        return $this->hasMany('App\Models\MouvementStock', 'id_aliment');
    }

    public function uniteSortie()
    {
        return $this->belongsTo('App\Models\Unite', 'unite_sortie');
    }

}